/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.client.infrastructure.particle.CubeParticleRenderer;
import com.zurrtum.create.client.infrastructure.particle.CubeParticleSubmittable;
import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class CubeParticle
extends class_703 {
    protected float scale;
    protected boolean hot;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    private boolean billowing = false;

    public CubeParticle(class_638 world, CubeParticleData data, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_3852 = motionX;
        this.field_3869 = motionY;
        this.field_3850 = motionZ;
        this.setColor(data.red(), data.green(), data.blue());
        this.setScale(data.scale());
        this.averageAge(data.avgAge());
        this.setHot(data.hot());
    }

    public void setColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.method_3080(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        this.field_3847 = (int)((double)age + (this.field_3840.method_43058() * 2.0 - 1.0) * 8.0);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public void method_3070() {
        if (this.hot && this.field_3866 > 0) {
            if (this.field_3838 == this.field_3854) {
                this.billowing = true;
                this.field_21507 = false;
                if (this.field_3852 == 0.0 && this.field_3850 == 0.0) {
                    class_243 diff = class_243.method_24954((class_2382)class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)).method_1031(0.5, 0.5, 0.5).method_1023(this.field_3874, this.field_3854, this.field_3871);
                    this.field_3852 = -diff.field_1352 * 0.1;
                    this.field_3850 = -diff.field_1350 * 0.1;
                }
                this.field_3852 *= 1.1;
                this.field_3869 *= 0.9;
                this.field_3850 *= 1.1;
            } else if (this.billowing) {
                this.field_3869 *= 1.2;
            }
        }
        super.method_3070();
    }

    public void render(CubeParticleSubmittable submittable, class_4184 camera, float tickProgress) {
        class_243 projectedView = camera.method_71156();
        float lerpedX = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3858, (double)this.field_3874) - projectedView.method_10216());
        float lerpedY = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3838, (double)this.field_3854) - projectedView.method_10214());
        float lerpedZ = (float)(class_3532.method_16436((double)tickProgress, (double)this.field_3856, (double)this.field_3871) - projectedView.method_10215());
        double ageMultiplier = 1.0 - Math.pow(class_3532.method_15363((float)((float)this.field_3866 + tickProgress), (float)0.0f, (float)this.field_3847), 3.0) / Math.pow(this.field_3847, 3.0);
        float scale = (float)((double)this.scale * ageMultiplier);
        int color = class_9848.method_61318((float)this.alpha, (float)this.red, (float)this.green, (float)this.blue);
        submittable.render(lerpedX, lerpedY, lerpedZ, scale, color);
    }

    public class_3999 method_74274() {
        return CubeParticleRenderer.SHEET;
    }

    public boolean shouldRender(class_4604 frustum) {
        return frustum.method_74404(this.field_3874, this.field_3854, this.field_3871);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<CubeParticleData> {
        public class_703 createParticle(CubeParticleData data, class_638 world, double x, double y, double z, double motionX, double motionY, double motionZ, class_5819 random) {
            return new CubeParticle(world, data, x, y, z, motionX, motionY, motionZ);
        }
    }
}

